/*!Copyright(c) 2010-2014 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 *\file     msgcenter.h
 *\brief    
 *
 *\author   liang liang
 *\version  1.0.0
 *\date     2014-07-05
 *
 *\history 
 *                  
 *          \arg 1.0.0, 2014-07-05, liang liang, Create the file.
 */


#ifndef __MSGCENTER_H_
#define __MSGCENTER_H_

#include "os_dep.h"
#include "mc_list.h"
#include "mc_common.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MC_SYNC_CALLBACK_FUNC "mc_sub_sync_callback"

typedef struct _mc_attach_info
{
    mc_list list;
    mc_list data_list; //list mc_data_elem
    os_u32 ref_count;
    void* dl_handle;
    mc_sync_callback cb;
    MC_REG_INFO info;
}mc_attach_info;


typedef struct _mc_event_list
{
    mc_list list_head; //list mc_event_elem
}mc_event_list;

typedef struct _mc_data_unack
{
    mc_list list;
    os_u32 ref_count;
    os_u32 try_send;
    os_u32 time;
    MC_EVENT_DATA data;
}mc_data_unack;


typedef struct _mc_data_elem
{
    mc_list list;
    mc_data_unack* unack_data;
}mc_data_elem;

typedef struct _mc_server
{
    os_s32 udp_sock;
    os_s32 unix_sock;
    os_u32 calloc;
    os_u32 free;
    //mc_event_list event[MC_EVENT_MAX];
    mc_list data_list; //list mc_data_unack
    mc_list reg_list; //list mc_attach_info
}mc_server;

os_s32 mc_init_server(void);
os_s32 mc_run_server(void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MSGCENTER_H_ */

